/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.Input;

import BryceMath.Factories.MatrixFactory;
import BryceMath.Factories.VectorFactory;
import BryceMath.Numbers.Equation;
import BryceMath.Numbers.Number;
import BryceMath.Structures.Matrix;
import BryceMath.Structures.Vector;
import Data_Structures.Structures.List;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.GUI.Components.Input.Input;
import Game_Engine.GUI.Components.Input.gui_IntegerInput;
import Game_Engine.GUI.Components.Input.textBased.gui_EquationInput;
import Game_Engine.GUI.Components.large.gui_grid;
import Game_Engine.GUI.Components.large.gui_list;
import Game_Engine.GUI.Components.large.gui_window;
import Game_Engine.GUI.Components.small.boxes.gui_focusBox;
import Game_Engine.GUI.Components.small.gui_button;
import Game_Engine.GUI.Components.small.gui_label;
import java.awt.Color;
import util.interfaces.Generator;

public class gui_MatrixInput
extends Obj
implements Input<Matrix<Equation>> {
    private static int MAX_ROWS = 10;
    private static int MAX_COLUMNS = 10;
    gui_grid<gui_EquationInput> matrix;
    final String DEFAULT_INPUT = "0";
    final Matrix<Equation> original_matrix;
    gui_list button_list;
    gui_grid<gui_EquationInput> matrixGrid;
    gui_label col_num_label;
    gui_label row_num_label;
    gui_IntegerInput column_num_box;
    gui_IntegerInput row_num_box;
    gui_button transpose_button;
    gui_button clear_button;
    gui_button identity_button;
    gui_button conjugate_button;
    gui_button inverse_button;
    gui_button determinant_button;
    gui_button delete_button;
    gui_button shift_left_button;
    gui_button shift_right_button;
    private final int ROW_H;

    public gui_MatrixInput(int x, int y, int row_h) {
        super(x, y);
        this.ROW_H = row_h;
        this.original_matrix = null;
    }

    public gui_MatrixInput(int x, int y, int row_h, Matrix<Equation> matrix) {
        super(x, y);
        this.ROW_H = row_h;
        this.original_matrix = matrix;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setCollidable(false);
        this.setVisible(false);
        this.button_list = new gui_list(this.getX(), this.getY(), 250, (int)((double)this.myContainer.getH() - this.getY()));
        this.obj_create(this.button_list);
        this.populateList(this.button_list);
        this.button_list.makeTransparent();
        this.matrixGrid = new gui_grid<gui_EquationInput>(this.button_list.getX2(), this.button_list.getY(), this.myContainer.getW() - this.button_list.getW(), this.button_list.getH(), new BoxCreator(), true, this.ROW_H);
        this.obj_create(this.matrixGrid);
        this.clearInput();
    }

    private void populateList(gui_list L) {
        int bsize = 2;
        gui_window W = new gui_window(0.0, 0.0, L.getW() - bsize * 2, 50);
        L.add(W);
        gui_label l = new gui_label(-bsize, -bsize, 200, 50);
        l.setText("Row #");
        this.row_num_label = l;
        l.fitToContents();
        int label_w = l.getW();
        W.obj_create((Obj)l);
        this.row_num_box = new gui_IntegerInput(l.getX2(), l.getY(), 50, 50);
        this.row_num_box.disableNegatives();
        this.row_num_box.setText("1");
        this.row_num_box.setMaxLen(1);
        W.obj_create((Obj)this.row_num_box);
        this.row_num_box.INFO("Set the number of rows in the matrix: [1, 9]");
        W = new gui_window(0.0, 0.0, L.getW() - bsize * 2, 50);
        L.add(W);
        l = new gui_label(-bsize, -bsize, 200, 50);
        l.setText("Col #");
        l.setW(label_w);
        this.col_num_label = l;
        W.obj_create((Obj)l);
        this.column_num_box = new gui_IntegerInput(l.getX2(), l.getY(), 50, 50);
        this.column_num_box.disableNegatives();
        this.column_num_box.setText("1");
        this.column_num_box.setMaxLen(1);
        W.obj_create((Obj)this.column_num_box);
        this.column_num_box.INFO("Set the number of columns in the matrix: [1, 9]");
        this.clear_button = this.OP_BUTTON("clear_button", L);
        this.clear_button.INFO("Set every selected element to 0.");
        this.delete_button = this.OP_BUTTON("delete", L);
        this.delete_button.INFO("Removes the selected elements from the matrix.");
        this.shift_left_button = this.OP_BUTTON("Shift Left", L);
        this.shift_left_button.INFO("Shift the selected row or column left or up.");
        this.shift_right_button = this.OP_BUTTON("Shift Right", L);
        this.shift_right_button.INFO("Shift the selected row or column right or down.");
        this.transpose_button = this.OP_BUTTON("Transpose", L);
        this.transpose_button.INFO("Transpose the current matrix.");
        this.inverse_button = this.OP_BUTTON("Invert", L);
        this.inverse_button.INFO("Invert the current input if possible.");
        this.determinant_button = this.OP_BUTTON("Determinant", L);
        this.determinant_button.INFO("Compute the Determinant of a square matrix.");
        this.conjugate_button = this.OP_BUTTON("conjugate", L);
        this.conjugate_button.INFO("Conjugates every seleted element.");
        this.identity_button = this.OP_BUTTON("Identity", L);
        this.identity_button.INFO("Sets every element on the diagonal to 1 and all other elements to 0.");
    }

    private gui_button OP_BUTTON(String str, gui_list container) {
        gui_button output = new gui_button(0.0, 0.0, container.getWorld().getW(), 50);
        output.setText(str);
        container.add(output);
        return output;
    }

    @Override
    public void clearInput() {
        if (this.original_matrix != null) {
            this.populateInput(this.original_matrix);
            this.getBox(0).toggle();
            return;
        }
        int r = 0;
        while (r < this.num_rows()) {
            int c = 0;
            while (c < this.num_columns()) {
                gui_EquationInput box = this.getBox(r, c);
                box.clearInput();
                box.setDefaultEquation(Equation.ZERO);
                ++c;
            }
            ++r;
        }
        this.getBox(0).toggle();
    }

    public void populateInput(Equation eq) {
        Equation[][] data = new Equation[1][1];
        data[0][0] = eq;
        this.populateInput(data);
    }

    public void populateInput(Equation[][] data) {
        this.populateInput(new Matrix((Number[][])data));
    }

    public void populateInput(Matrix<Equation> matrix) {
        while (this.num_columns() > 1) {
            this.matrixGrid.remCol();
        }
        while (this.num_rows() > 1) {
            this.matrixGrid.remRow();
        }
        int rowNum = matrix.getRowNum();
        int colNum = matrix.getColNum();
        int c = 0;
        while (c < colNum - 1) {
            this.matrixGrid.addCol();
            ++c;
        }
        int r = 0;
        while (r < rowNum - 1) {
            this.matrixGrid.addRow();
            ++r;
        }
        r = 0;
        while (r < this.num_rows()) {
            int c2 = 0;
            while (c2 < this.num_columns()) {
                this.getBox(r, c2).populateInput(matrix.get(r, c2).toSerialString());
                ++c2;
            }
            ++r;
        }
    }

    @Override
    public boolean input_changed() {
        throw new Error("Implement Me!");
    }

    @Override
    public boolean query_changed() {
        throw new Error("Implement Me!");
    }

    @Override
    public void update() {
        this.proccessButtons();
    }

    /*
     * Unable to fully structure code
     */
    private void proccessButtons() {
        block14: {
            block13: {
                if (!this.row_num_box.input_changed()) break block13;
                rows = this.row_num_box.getInput().toInt();
                if ((rows = Math.min(rows, gui_MatrixInput.MAX_ROWS)) != 0) ** GOTO lbl6
                return;
lbl-1000:
                // 1 sources

                {
                    this.matrixGrid.remRow();
lbl6:
                    // 2 sources

                    ** while (rows < this.num_rows())
                }
lbl7:
                // 2 sources

                while (rows > this.num_rows()) {
                    this.matrixGrid.addRow();
                }
                return;
            }
            if (!this.column_num_box.input_changed()) break block14;
            col = this.column_num_box.getInput().toInt();
            if ((col = Math.min(col, gui_MatrixInput.MAX_COLUMNS)) != 0) ** GOTO lbl17
            return;
lbl-1000:
            // 1 sources

            {
                this.matrixGrid.remCol();
lbl17:
                // 2 sources

                ** while (col < this.num_columns())
            }
lbl18:
            // 2 sources

            while (col > this.num_columns()) {
                this.matrixGrid.addCol();
            }
            return;
        }
        if (this.transpose_button.flag()) {
            this.data_transpose();
            return;
        }
        if (this.clear_button.flag()) {
            this.data_clear_selected();
            return;
        }
        if (this.identity_button.flag()) {
            this.data_identity();
            return;
        }
        if (this.conjugate_button.flag()) {
            this.data_conjugate();
            return;
        }
        if (this.inverse_button.flag()) {
            this.data_invert();
            return;
        }
        if (this.determinant_button.flag()) {
            this.data_determinant();
            return;
        }
        if (this.delete_button.flag()) {
            this.data_delete();
        }
        if (this.shift_left_button.flag() && this.data_shift_left()) {
            gui_MatrixInput.eraseSelections();
        }
        if (this.shift_right_button.flag() && this.data_shift_right()) {
            gui_focusBox.eraseSelections();
        }
    }

    private void obj_create(Obj o) {
        this.myContainer.obj_create(o);
    }

    @Override
    public Matrix<Equation> getInput() {
        List<Vector<Equation>> col_output = new List<Vector<Equation>>();
        int c = 0;
        while (c < this.num_columns()) {
            col_output.add(this.getColumnVector(c));
            ++c;
        }
        return MatrixFactory.m_ex_col((Vector[])col_output.toArray());
    }

    private Vector<Equation> getColumnVector(int colNum) {
        Equation[] column = new Equation[this.num_rows()];
        int r = 0;
        while (r < this.num_rows()) {
            column[r] = this.getBox(r, colNum).getInput();
            ++r;
        }
        return VectorFactory.v(column);
    }

    @Override
    public void keyP(int key) {
        super.keyP(key);
        if (key == 9) {
            int selection = this.getSelected();
            if (selection == -1) {
                this.getBox(0).toggle();
                return;
            }
            if (selection < this.num_rows() * this.num_columns() - 1) {
                this.getBox(selection + 1).toggle();
            } else {
                this.getBox(0).toggle();
            }
        }
    }

    public gui_EquationInput getBox(int row, int col) {
        return this.matrixGrid.getBox(row, col);
    }

    private gui_EquationInput getBox(int number) {
        return this.matrixGrid.getBox(number);
    }

    private gui_EquationInput I_BOX() {
        gui_EquationInput output = new gui_EquationInput(-500.0, -500.0, 10, this.ROW_H);
        output.setDefaultEquation(Equation.ZERO);
        output.setAutoFit(false);
        output.INFO("Select this number box.");
        return output;
    }

    private void data_transpose() {
        Object m = this.getInput();
        this.populateInput(((Matrix)m).transpose());
    }

    private void data_clear_all() {
        List<gui_EquationInput> selections = this.matrixGrid.getAll();
        this.data_clear(selections);
    }

    private void data_clear_selected() {
        List<gui_EquationInput> selections = this.getSelections();
        this.data_clear(selections);
    }

    private void data_clear(List<gui_EquationInput> selections) {
        if (selections.isEmpty()) {
            this.clear_button.ERROR("Nothing is Selected.");
            return;
        }
        for (gui_EquationInput box : selections) {
            box.clearInput();
        }
    }

    private void data_conjugate() {
        List<gui_EquationInput> selections = this.getSelections();
        for (gui_EquationInput box : selections) {
            Equation eq = box.getInput();
            box.populateInput(eq.conj().toSerialString());
        }
    }

    private void data_invert() {
        Matrix<Equation> m;
        try {
            m = ((Matrix)this.getInput()).inverse();
        }
        catch (Error e) {
            this.inverse_button.ERROR(e.getMessage());
            return;
        }
        if (m != null) {
            this.populateInput(m);
            return;
        }
        this.inverse_button.ERROR("Matrix has no inverse!");
    }

    private void data_identity() {
        this.data_clear_all();
        int min = Math.min(this.num_rows(), this.num_columns());
        int i = 0;
        while (i < min) {
            this.getBox(i, i).populateInput(Equation.ONE.toSerialString());
            ++i;
        }
    }

    private void data_delete() {
        int row = this.matrixGrid.getSelectedRow();
        if (row != -1) {
            try {
                this.matrixGrid.remRow(row);
            }
            catch (Error e) {
                this.delete_button.ERROR(e.getMessage());
            }
            return;
        }
        int col = this.matrixGrid.getSelectedColumn();
        if (col != -1) {
            try {
                this.matrixGrid.remCol(col);
            }
            catch (Error e) {
                this.delete_button.ERROR(e.getMessage());
            }
            return;
        }
        this.delete_button.ERROR("No row or column is currently selected");
    }

    public void setColor(Color c) {
        this.button_list.setColor(c);
        this.matrixGrid.setColor(c);
    }

    private int num_rows() {
        return this.matrixGrid.getNumRows();
    }

    private int num_columns() {
        return this.matrixGrid.getNumColumns();
    }

    private List<gui_EquationInput> getSelections() {
        int index;
        List<gui_EquationInput> output = this.matrixGrid.getSelections();
        if (output != null) {
            return output;
        }
        if (output == null && (index = this.getSelected()) != -1) {
            return new List<gui_EquationInput>(this.getBox(index));
        }
        return this.matrixGrid.getAll();
    }

    public boolean isSelected() {
        return this.getSelected() != -1;
    }

    private int getSelected() {
        int r = 0;
        while (r < this.num_rows()) {
            int c = 0;
            while (c < this.num_columns()) {
                if (this.getBox(r, c).isLastSelection()) {
                    return r * this.num_columns() + c;
                }
                ++c;
            }
            ++r;
        }
        return -1;
    }

    private boolean data_shift_left() {
        int rowNum = this.matrixGrid.getSelectedRow();
        if (rowNum > 0) {
            this.matrixGrid.shiftRowLeft(rowNum);
            return true;
        }
        if (rowNum == 0) {
            this.shift_left_button.ERROR("Cannot shift the topmost row up!");
            return false;
        }
        int colNum = this.matrixGrid.getSelectedColumn();
        if (colNum > 0) {
            this.matrixGrid.shiftColumnLeft(colNum);
            return true;
        }
        if (colNum == 0) {
            this.shift_left_button.ERROR("Cannot shift the leftmost column left!");
            return false;
        }
        this.delete_button.ERROR("No row or column is currently selected");
        return false;
    }

    private boolean data_shift_right() {
        int rowNum = this.matrixGrid.getSelectedRow();
        if (rowNum != -1) {
            if (rowNum < this.matrixGrid.getNumRows() - 1) {
                this.matrixGrid.shiftRowRight(rowNum);
                return true;
            }
            this.shift_right_button.ERROR("Cannot shift the bottomost row down!");
            return false;
        }
        int colNum = this.matrixGrid.getSelectedColumn();
        if (colNum != -1) {
            if (colNum < this.matrixGrid.getNumColumns() - 1) {
                this.matrixGrid.shiftColumnRight(colNum);
                return true;
            }
            this.shift_right_button.ERROR("Cannot shift the rightmost column right!");
            return false;
        }
        this.shift_right_button.ERROR("No row or column selected!");
        return false;
    }

    private void data_determinant() {
        Object m = this.getInput();
        if (((Matrix)m).getRowNum() != ((Matrix)m).getColNum()) {
            this.determinant_button.ERROR("Error: Non Square Matrices have no determinant.");
        }
        Equation det = (Equation)((Matrix)this.getInput()).det();
        if (m != null) {
            this.populateInput(det);
            return;
        }
        this.determinant_button.ERROR("Matrix has no determinant!");
    }

    private class BoxCreator
    implements Generator<gui_EquationInput> {
        private BoxCreator() {
        }

        @Override
        public gui_EquationInput create() {
            return gui_MatrixInput.this.I_BOX();
        }
    }
}

